#!/usr/bin/env python
# Duplicate Project

# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050802 - first version of this script
# 050805 - more changes, first working version
# 050808 - clear PercentComplete in duplicated tasks

if debug: print 'Start Duplicate Project'

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def DuplicateProject(self):
    rid = self.ReportID  # current report
    if rid != 1 :
        hint('Use only on main report')
        return  # do nothing

    if self.Report.currentItem == None: 
        hint("Must select project")
        return

    # get the definition of the currently selected report row
    # use the report's cross reference 'row' to translates the 'item #' into 'row id #'
    reportrowid = self.Report.rows[self.Report.currentItem]  # item -> report row id
    rr = self.Report.reportrow[reportrowid]  # report row id -> report row record

    # make sure that a project row is selected
    rowtable = rr['TableName']
    rowid = rr['TableID']
    if debug: print 'rowtable:', rowtable
    if debug: print 'rowid:', rowid
    if rowtable != 'Project':
        hint("Must select project")
        return
    if rowid == 1:
        hint("Cannot duplicate 'All Projects' project")
        return

    # short cuts for tables to be copied
    dp = Data.Database.get('Project')
    dt = Data.Database.get('Task')
    dd = Data.Database.get('Dependency')
    dcl = Data.Database.get('Checklist')
    dr = Data.Database.get('Report')
    drr = Data.Database.get('ReportRow')
    drc = Data.Database.get('ReportColumn')

    # create table for id conversions
    old2new = {}

    # copy project
    projectid = rowid
    change = dp[projectid].copy()
    if change.has_key('ID'): del change['ID']
    change['Table'] = 'Project'

    name = change.get('Name') or '-'
    change['Name'] = name + " Copy"

    undo = Data.Update(change)
    old2new[('Project', projectid)] = undo['ID']

    # copy tasks
    newtask = [ ]
    for k, v in dt.items():

        # test whether to copy
        pid = v.get('ProjectID')
        if not pid or pid != projectid: continue
        if v.get('zzStatus') == 'deleted': continue

        change = v.copy()
        if change.has_key('ID'): del change['ID']
        if change.has_key('ActualEndDate'): del change['ActualEndDate']
        if change.has_key('PercentComplete'): del change['PercentComplete']

        change['Table'] = 'Task'
        undo = Data.Update(change)
        newtask.append(undo['ID'])

        # xref
        old2new[('Task', k)] = undo['ID']
        old2new[('Prerequisite', k)] = undo['ID']

    # copy dependency
    newdependency = [ ]
    if dd:
        for k, v in dd.items():

            # test whether to copy
            if v.get('zzStatus') == 'deleted': continue
            tid = v.get('TaskID')
            if not tid or not dt.has_key(tid): continue
            pid = dt[tid].get('ProjectID')
            if not pid or pid != projectid: continue

            tid = v.get('PrerequisiteID')
            if not tid or not dt.has_key(tid): continue
            pid = dt[tid].get('ProjectID')
            if not pid or pid != projectid: continue

            change = v.copy()
            if change.has_key('ID'): del change['ID']
            change['Table'] = 'Dependency'
            undo = Data.Update(change)
            newdependency.append(undo['ID'])

            # xref
            old2new[('Dependency', k)] = undo['ID']

    # copy checklist
    newchecklist = [ ]
    if dcl:
        for k, v in dcl.items():

            # test whether to copy
            if v.get('zzStatus') == 'deleted': continue
            tid = v.get('TaskID')
            if not tid or not dt.has_key(tid): continue
            pid = dt[tid].get('ProjectID')
            if not pid or pid != projectid: continue

            change = v.copy()
            if change.has_key('ID'): del change['ID']
            # maybe change 'Data Added' to current date?
            if change.has_key('ActualEndDate'): del change['ActualEndDate']
            # maybe change 'Data Added' to current date?

            change['Table'] = 'Checklist'
            undo = Data.Update(change)
            newchecklist.append(undo['ID'])

            # xref
            old2new[('Checklist', k)] = undo['ID']

    # copy reports
    newreport = [ ]
    for k, v in dr.items():

        # test whether to copy
        if v.get('zzStatus') == 'deleted': continue
        pid = v.get('ProjectID')
        if not pid or pid != projectid: continue

        change = v.copy()
        if change.has_key('ID'): del change['ID']
        change['Table'] = 'Report'

        # update report selection criteria
        if change.get('SelectColumn') == 'ProjectID':  # what about other values?
            change['SelectValue'] = old2new[('Project', projectid)]

        undo = Data.Update(change)
        newreport.append(undo['ID'])

        # xref
        old2new[('Report', k)] = undo['ID']

    # copy report rows and columns
    for k in newreport:  # new reports all point to old report rows

        # copy report rows
        old = Data.GetRowList(k) # get list of report rows
        newrows = [ ]

        for o in old:
            if drr[o].get('zzStatus') == 'deleted': continue
            change = drr[o].copy()
            if change.has_key('ID'): del change['ID']
            change['Table'] = 'ReportRow'
            change['ReportID'] = k

            # fix row's tableid
            table = change.get('TableName')
            oldid = change.get('TableID')
            change['TableID'] = old2new.get((table, oldid))

            undo = Data.Update(change)
            newrows.append(undo['ID'])

        # copy report columns
        old = Data.GetColumnList(k) # get list of report rows
        newcolumns = [ ]

        for o in old:
            if drc[o].get('zzStatus') == 'deleted': continue
            change = drc[o].copy()
            if change.has_key('ID'): del change['ID']
            change['Table'] = 'ReportColumn'
            change['ReportID'] = k

            undo = Data.Update(change)
            newcolumns.append(undo['ID'])

        # clear first row and first column
        change = { 'Table': 'Report', 'ID': k, 'FirstRow': 0, 'FirstColumn': 0 }
        undo = Data.Update(change)
        Data.ReorderReportRows(k, newrows)  # set the row linked list
        Data.ReorderReportColumns(k, newcolumns)  # set the column linked list

    # adjust foreign keys
    def AdjustFK(table, ids):
        for t in ids:
            change = { 'Table': table, 'ID': t }
            for k, v in Data.Database[table][t].items():  # scan through columns
                if k != 'ID' and k[-2:] == 'ID':  # FK ends with ID
                    oldkey = v
                    newkey = old2new.get((k[:-2], oldkey))  # table name
                    if newkey: change[k] = newkey
            if len(change) > 2:
                if debug: print "AdjustFK", change
                Data.Update(change)

    AdjustFK('Task', newtask)
    AdjustFK('Dependency', newdependency)
    AdjustFK('Checklist', newchecklist)
    AdjustFK('Report', newreport)

    Data.SetUndo("Duplicate Project")

if debug: print 'End Script'

DuplicateProject(self)
